﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class OUTPAT_VISITDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public OUTPAT_VISITDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public List<OUTPAT_VISIT> GetItemsByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<OUTPAT_VISIT> objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_OUTPAT_VISIT_getitemsByReferral", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);
                sCmd.Parameters.AddWithValue("@REFERRAL_ID", REFERRAL_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    var myData = objTemp.Tables[0].AsEnumerable().Select(r => ParseReader(r));
                    if (myData != null)
                    {
                        objReturn = myData.ToList<OUTPAT_VISIT>();
                    }
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public OUTPAT_VISIT ParseReader(DataRow row)
        {
            OUTPAT_VISIT objReturn = new OUTPAT_VISIT
            {
                AGENTORANGEFLAG = (string)GetNullableObject(row.Field<object>("AGENTORANGEFLAG")),
                APPOINTMENTSTATUSSID = (Int16?)GetNullableObject(row.Field<object>("APPOINTMENTSTATUSSID")),
                APPOINTMENTTYPESID = (Int16?)GetNullableObject(row.Field<object>("APPOINTMENTTYPESID")),
                CHECKOUTDATETIME = (DateTime?)GetNullableObject(row.Field<object>("CHECKOUTDATETIME")),
                CHECKOUTDATETIMETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("CHECKOUTDATETIMETRANSFORMSID")),
                CHECKOUTVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("CHECKOUTVISTAERRORDATE")),
                COMBATFLAG = (string)GetNullableObject(row.Field<object>("COMBATFLAG")),
                COPROCESSCOMPLETEDATETIME = (DateTime?)GetNullableObject(row.Field<object>("COPROCESSCOMPLETEDATETIME")),
                COPROCESSCOMPLETEDATETIMETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("COPROCESSCOMPLETEDATETIMETRANSFORMSID")),
                COPROCESSCOMPLETEVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("COPROCESSCOMPLETEVISTAERRORDATE")),
                COUNTY = (string)GetNullableObject(row.Field<object>("COUNTY")),
                Created = (DateTime?)GetNullableObject(row.Field<object>("Created")),
                CreatedBy = (string)GetNullableObject(row.Field<object>("CreatedBy")),
                CREATEDBYSTAFFSID = (Int32?)GetNullableObject(row.Field<object>("CREATEDBYSTAFFSID")),
                CREATERECORDMENUOPTIONSID = (Int32?)GetNullableObject(row.Field<object>("CREATERECORDMENUOPTIONSID")),
                DIAGNOSISCOUNT = (Int16?)GetNullableObject(row.Field<object>("DIAGNOSISCOUNT")),
                DIVISIONSID = (Int16?)GetNullableObject(row.Field<object>("DIVISIONSID")),
                ELIGIBILITYSID = (Int32?)GetNullableObject(row.Field<object>("ELIGIBILITYSID")),
                ENCOUNTERCOMPUTERGENERATEDFLAG = (string)GetNullableObject(row.Field<object>("ENCOUNTERCOMPUTERGENERATEDFLAG")),
                ENCOUNTERCREATEDBYSTAFFSID = (Int32?)GetNullableObject(row.Field<object>("ENCOUNTERCREATEDBYSTAFFSID")),
                ENCOUNTERCREATEDDATETIME = (DateTime?)GetNullableObject(row.Field<object>("ENCOUNTERCREATEDDATETIME")),
                ENCOUNTERCREATEDDATETIMETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("ENCOUNTERCREATEDDATETIMETRANSFORMSID")),
                ENCOUNTERCREATEDVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("ENCOUNTERCREATEDVISTAERRORDATE")),
                ENCOUNTERDATETIME = (DateTime?)GetNullableObject(row.Field<object>("ENCOUNTERDATETIME")),
                ENCOUNTERDATETIMETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("ENCOUNTERDATETIMETRANSFORMSID")),
                ENCOUNTERDIVISIONSID = (Int16?)GetNullableObject(row.Field<object>("ENCOUNTERDIVISIONSID")),
                ENCOUNTERLASTEDITEDBYSTAFFSID = (Int32?)GetNullableObject(row.Field<object>("ENCOUNTERLASTEDITEDBYSTAFFSID")),
                ENCOUNTERLASTEDITEDDATETIME = (DateTime?)GetNullableObject(row.Field<object>("ENCOUNTERLASTEDITEDDATETIME")),
                ENCOUNTERLASTEDITEDDATETIMETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("ENCOUNTERLASTEDITEDDATETIMETRANSFORMSID")),
                ENCOUNTERLASTEDITEDVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("ENCOUNTERLASTEDITEDVISTAERRORDATE")),
                ENCOUNTERTYPE = (string)GetNullableObject(row.Field<object>("ENCOUNTERTYPE")),
                ENCOUNTERVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("ENCOUNTERVISTAERRORDATE")),
                ETLBATCHID = (Int32?)GetNullableObject(row.Field<object>("ETLBATCHID")),
                EXTENDEDREFERENCE = (string)GetNullableObject(row.Field<object>("EXTENDEDREFERENCE")),
                HEADNECKCANCERFLAG = (string)GetNullableObject(row.Field<object>("HEADNECKCANCERFLAG")),
                INSTITUTIONSID = (Int32?)GetNullableObject(row.Field<object>("INSTITUTIONSID")),
                IONIZINGRADIATIONFLAG = (string)GetNullableObject(row.Field<object>("IONIZINGRADIATIONFLAG")),
                LASTMODIFIEDDATETIME = (DateTime?)GetNullableObject(row.Field<object>("LASTMODIFIEDDATETIME")),
                LASTMODIFIEDDATETIMETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("LASTMODIFIEDDATETIMETRANSFORMSID")),
                LASTMODIFIEDVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("LASTMODIFIEDVISTAERRORDATE")),
                LOCATIONSID = (Int32?)GetNullableObject(row.Field<object>("LOCATIONSID")),
                MILITARYSEXUALTRAUMAFLAG = (string)GetNullableObject(row.Field<object>("MILITARYSEXUALTRAUMAFLAG")),
                NONCOUNTCLINICFLAG = (string)GetNullableObject(row.Field<object>("NONCOUNTCLINICFLAG")),
                NONVAVISITTYPE = (string)GetNullableObject(row.Field<object>("NONVAVISITTYPE")),
                OPCODE = (string)GetNullableObject(row.Field<object>("OPCODE")),
                ORIGINATINGPROCESSTYPE = (string)GetNullableObject(row.Field<object>("ORIGINATINGPROCESSTYPE")),
                PARENTVISITSID = (Int64?)GetNullableObject(row.Field<object>("PARENTVISITSID")),
                PATIENTAGENTORANGEFLAG = (string)GetNullableObject(row.Field<object>("PATIENTAGENTORANGEFLAG")),
                PATIENTAGENTORANGELOCATIONCODE = (string)GetNullableObject(row.Field<object>("PATIENTAGENTORANGELOCATIONCODE")),
                PATIENTCOMBATENDDATE = (DateTime?)GetNullableObject(row.Field<object>("PATIENTCOMBATENDDATE")),
                PATIENTCOMBATENDDATETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("PATIENTCOMBATENDDATETRANSFORMSID")),
                PATIENTCOMBATENDVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("PATIENTCOMBATENDVISTAERRORDATE")),
                PATIENTCOMBATINDICATEDFLAG = (string)GetNullableObject(row.Field<object>("PATIENTCOMBATINDICATEDFLAG")),
                PATIENTDERIVEDMEANSTESTCATEGORY = (string)GetNullableObject(row.Field<object>("PATIENTDERIVEDMEANSTESTCATEGORY")),
                PATIENTFIPS = (string)GetNullableObject(row.Field<object>("PATIENTFIPS")),
                PATIENTIEN = (string)GetNullableObject(row.Field<object>("PATIENTIEN")),
                PATIENTINCOME = (decimal?)GetNullableObject(row.Field<object>("PATIENTINCOME")),
                PATIENTINSURANCECOVERAGEFLAG = (string)GetNullableObject(row.Field<object>("PATIENTINSURANCECOVERAGEFLAG")),
                PATIENTINSURANCETYPE = (string)GetNullableObject(row.Field<object>("PATIENTINSURANCETYPE")),
                PATIENTIONIZINGRADIATIONCODE = (string)GetNullableObject(row.Field<object>("PATIENTIONIZINGRADIATIONCODE")),
                PATIENTMARITALSTATUS = (string)GetNullableObject(row.Field<object>("PATIENTMARITALSTATUS")),
                PATIENTMEANSTESTSTATUS = (string)GetNullableObject(row.Field<object>("PATIENTMEANSTESTSTATUS")),
                PATIENTMILITARYSEXUALTRAUMAINDICATOR = (string)GetNullableObject(row.Field<object>("PATIENTMILITARYSEXUALTRAUMAINDICATOR")),
                PATIENTNOSETHROATRADIUMEXPOSUREFLAG = (string)GetNullableObject(row.Field<object>("PATIENTNOSETHROATRADIUMEXPOSUREFLAG")),
                PATIENTNUMBEROFDEPENDENTS = (Int32?)GetNullableObject(row.Field<object>("PATIENTNUMBEROFDEPENDENTS")),
                PATIENTPERCENTSERVICECONNECT = (Int32?)GetNullableObject(row.Field<object>("PATIENTPERCENTSERVICECONNECT")),
                PATIENTPERIODOFSERVICE = (string)GetNullableObject(row.Field<object>("PATIENTPERIODOFSERVICE")),
                PATIENTPOWFLAG = (string)GetNullableObject(row.Field<object>("PATIENTPOWFLAG")),
                PATIENTPOWLOCATION = (string)GetNullableObject(row.Field<object>("PATIENTPOWLOCATION")),
                PATIENTRELIGION = (string)GetNullableObject(row.Field<object>("PATIENTRELIGION")),
                PATIENTRELIGIONCODE = (Int32?)GetNullableObject(row.Field<object>("PATIENTRELIGIONCODE")),
                PATIENTSHIPBOARDHAZARDDEFENSEFLAG = (string)GetNullableObject(row.Field<object>("PATIENTSHIPBOARDHAZARDDEFENSEFLAG")),
                PATIENTSID = (Int32?)GetNullableObject(row.Field<object>("PATIENTSID")),
                PATIENTSOUTHWESTASIACONDITION = (string)GetNullableObject(row.Field<object>("PATIENTSOUTHWESTASIACONDITION")),
                PATIENTSTATUSINOUT = (string)GetNullableObject(row.Field<object>("PATIENTSTATUSINOUT")),
                PATIENTVETERANFLAG = (string)GetNullableObject(row.Field<object>("PATIENTVETERANFLAG")),
                PATIENTVIETNAMSERVICEFLAG = (string)GetNullableObject(row.Field<object>("PATIENTVIETNAMSERVICEFLAG")),
                PATIENTZIP = (string)GetNullableObject(row.Field<object>("PATIENTZIP")),
                PCEDATASOURCESID = (Int32?)GetNullableObject(row.Field<object>("PCEDATASOURCESID")),
                PRIMARYSTOPCODESID = (Int32?)GetNullableObject(row.Field<object>("PRIMARYSTOPCODESID")),
                PROCEDURECOUNT = (Int16?)GetNullableObject(row.Field<object>("PROCEDURECOUNT")),
                PROTOCOLSID = (Int32?)GetNullableObject(row.Field<object>("PROTOCOLSID")),
                PROVIDERCOUNT = (Int16?)GetNullableObject(row.Field<object>("PROVIDERCOUNT")),
                SECONDARYSTOPCODESID = (Int32?)GetNullableObject(row.Field<object>("SECONDARYSTOPCODESID")),
                SERVICECATEGORY = (string)GetNullableObject(row.Field<object>("SERVICECATEGORY")),
                SERVICECONNECTEDFLAG = (string)GetNullableObject(row.Field<object>("SERVICECONNECTEDFLAG")),
                SHIPBOARDHAZARDDEFENSEFLAG = (string)GetNullableObject(row.Field<object>("SHIPBOARDHAZARDDEFENSEFLAG")),
                STA3N = (Int16)GetNullableObject(row.Field<object>("STA3N")),
                StdRegistryId = (Int32?)GetNullableObject(row.Field<object>("StdRegistryId")),
                SWASIACONDITIONSFLAG = (string)GetNullableObject(row.Field<object>("SWASIACONDITIONSFLAG")),
                UNIQUEVISITNUMBER = (string)GetNullableObject(row.Field<object>("UNIQUEVISITNUMBER")),
                UNRESOLVEDAPPOINTMENTTYPEREASON = (string)GetNullableObject(row.Field<object>("UNRESOLVEDAPPOINTMENTTYPEREASON")),
                Updated = (DateTime?)GetNullableObject(row.Field<object>("Updated")),
                UpdatedBy = (string)GetNullableObject(row.Field<object>("UpdatedBy")),
                VISITCREATEDDATETIME = (DateTime?)GetNullableObject(row.Field<object>("VISITCREATEDDATETIME")),
                VISITCREATEDDATETIMETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("VISITCREATEDDATETIMETRANSFORMSID")),
                VISITCREATEDVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("VISITCREATEDVISTAERRORDATE")),
                VISITDATETIME = (DateTime?)GetNullableObject(row.Field<object>("VISITDATETIME")),
                VISITDATETIMETRANSFORMSID = (Int64?)GetNullableObject(row.Field<object>("VISITDATETIMETRANSFORMSID")),
                VISITDEPENDENTENTRYCOUNT = (Int16?)GetNullableObject(row.Field<object>("VISITDEPENDENTENTRYCOUNT")),
                VISITIDENTIFIER = (string)GetNullableObject(row.Field<object>("VISITIDENTIFIER")),
                VISITIEN = (string)GetNullableObject(row.Field<object>("VISITIEN")),
                VISITSID = (Int64)GetNullableObject(row.Field<object>("VISITSID")),
                VISITVISTAERRORDATE = (string)GetNullableObject(row.Field<object>("VISITVISTAERRORDATE")),
                VISTACREATEDATE = (DateTime?)GetNullableObject(row.Field<object>("VISTACREATEDATE")),
                VISTAEDITDATE = (DateTime?)GetNullableObject(row.Field<object>("VISTAEDITDATE")),
                VISTAPACKAGESID = (Int32?)GetNullableObject(row.Field<object>("VISTAPACKAGESID")),
                WORKLOADLOGICFLAG = (string)GetNullableObject(row.Field<object>("WORKLOADLOGICFLAG"))
            };

            return objReturn;
        }

        #endregion
    }
}
